<?php
require_once 'header.php';
require_once '../config.php'; // database connection ($pdo)

// === Get settings from DB ===
$stmt = $pdo->query("SELECT * FROM settings ORDER BY id DESC LIMIT 1");
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if ($row) {
    $cphone  = $row['phone'];
    $curl    = $row['url'];
    $cdomain = $row['domain'];
    $cname   = $row['domain_name'];
    $cpass   = $row['password'];       // Email password (cPanel email)
    $cemail  = $row['email2'];         // Your domain email (e.g., support@yourdomain.com)
    $cright  = $row['copyright'];
    $chost   = $row['contact_email'];  // SMTP host (e.g., mail.yourdomain.com)
    $cport   = $row['service1'];       // Usually 465 (SSL) or 587 (TLS)
    $title   = $row['title'];
}

// === EDIT MODE ===
$id = $_GET['id'] ?? null;
if (!$id) {
    die("❌ No package ID provided.");
}

// Fetch parcel info from packages
$stmt = $pdo->prepare("SELECT * FROM packages WHERE id = ?");
$stmt->execute([$id]);
$ordrow = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$ordrow) {
    die("❌ Package not found.");
}

// === UPDATE HANDLER ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'update') {
    try {
        $sql = "
            UPDATE packages SET
                comp_name = :comp_name,
                comp_location = :comp_location,
                comp_phone = :comp_phone,
                ship_cost = :ship_cost,
                sub_cost = :sub_cost,
                total_cost = :total_cost,
                delivery_status = :delivery_status,
                consignment_status = :consignment_status,
                billing_name = :billing_name,
                billing_cost = :billing_cost,
                current_location = :current_location,
                final_destination = :final_destination,
                consignment_quantity = :consignment_quantity,
                arrival_date = :arrival_date,
                departure_date = :departure_date,
                arrival_time = :arrival_time,
                parcel_name = :parcel_name,
                parcel_details = :parcel_details,
                shipment_to = :shipment_to,
                shipment_from = :shipment_from,
                tracking_code = :tracking_code,
                recv_name = :recv_name,
                recv_email = :recv_email,
                recv_address = :recv_address,
                recv_phone = :recv_phone,
                recv_location = :recv_location,
                sdr_name = :sdr_name,
                sdr_address = :sdr_address,
                sdr_phone = :sdr_phone,
                sdr_location = :sdr_location
            WHERE id = :id
        ";

        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':comp_name' => $_POST['comp_name'],
            ':comp_location' => $_POST['comp_location'],
            ':comp_phone' => $_POST['comp_phone'],
            ':ship_cost' => $_POST['ship_cost'],
            ':sub_cost' => $_POST['sub_cost'],
            ':total_cost' => $_POST['total_cost'],
            ':delivery_status' => $_POST['delivery_status'],
            ':consignment_status' => $_POST['consignment_status'],
            ':billing_name' => $_POST['billing_name'],
            ':billing_cost' => $_POST['billing_cost'],
            ':current_location' => $_POST['current_location'],
            ':final_destination' => $_POST['final_destination'],
            ':consignment_quantity' => $_POST['consignment_quantity'],
            ':arrival_date' => $_POST['arrival_date'],
            ':departure_date' => $_POST['departure_date'],
            ':arrival_time' => $_POST['arrival_time'],
            ':parcel_name' => $_POST['parcel_name'],
            ':parcel_details' => $_POST['parcel_details'],
            ':shipment_to' => $_POST['shipment_to'],
            ':shipment_from' => $_POST['shipment_from'],
            ':tracking_code' => $_POST['tracking_code'],
            ':recv_name' => $_POST['recv_name'],
            ':recv_email' => $_POST['recv_email'],
            ':recv_address' => $_POST['recv_address'],
            ':recv_phone' => $_POST['recv_phone'],
            ':recv_location' => $_POST['recv_location'],
            ':sdr_name' => $_POST['sdr_name'],
            ':sdr_address' => $_POST['sdr_address'],
            ':sdr_phone' => $_POST['sdr_phone'],
            ':sdr_location' => $_POST['sdr_location'],
            ':id' => $id
        ]);

        echo "<script>
            alert('✅ Package updated successfully!');
            window.location.href = 'list_parcel.php';
        </script>";
        exit;

    } catch (Exception $e) {
        echo "<script>alert('❌ Error: " . addslashes($e->getMessage()) . "');</script>";
    }
}
?>








        <div wire:id="0ho7JEz65LVMGIzD4ceZ" wire:initial-data="{&quot;fingerprint&quot;:{&quot;id&quot;:&quot;0ho7JEz65LVMGIzD4ceZ&quot;,&quot;name&quot;:&quot;admin.manage-users&quot;,&quot;locale&quot;:&quot;en&quot;,&quot;path&quot;:&quot;admin\/dashboard\/manageusers&quot;,&quot;method&quot;:&quot;GET&quot;,&quot;v&quot;:&quot;acj&quot;},&quot;effects&quot;:{&quot;listeners&quot;:[],&quot;path&quot;:&quot;https:\/\/xtbtrading.live\/trade\/admin\/dashboard\/manageusers&quot;},&quot;serverMemo&quot;:{&quot;children&quot;:[],&quot;errors&quot;:[],&quot;htmlHash&quot;:&quot;ed570425&quot;,&quot;data&quot;:{&quot;pagenum&quot;:10,&quot;searchvalue&quot;:&quot;&quot;,&quot;orderby&quot;:&quot;id&quot;,&quot;orderdirection&quot;:&quot;desc&quot;,&quot;selectPage&quot;:false,&quot;selectAll&quot;:false,&quot;checkrecord&quot;:[],&quot;selected&quot;:&quot;&quot;,&quot;action&quot;:&quot;Delete&quot;,&quot;username&quot;:null,&quot;fullname&quot;:null,&quot;email&quot;:null,&quot;password&quot;:null,&quot;message&quot;:null,&quot;subject&quot;:null,&quot;plan&quot;:null,&quot;datecreated&quot;:null,&quot;topamount&quot;:null,&quot;toptype&quot;:null,&quot;topcolumn&quot;:&quot;Bonus&quot;,&quot;page&quot;:1,&quot;paginators&quot;:{&quot;page&quot;:1}},&quot;dataMeta&quot;:[],&quot;checksum&quot;:&quot;9e82a6adabccc53607a584c57da8f89b4130352eb62c7aa9cc50f9455ca3c494&quot;}}">
    <div class="main-panel">
        <div class="content bg-light">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 text-dark">Edit Parcel</h1>
                </div>
                <div>
    </div>                <div>
    </div>                
               
               
               
               
                <div class="mb-5 row">
                    <div class="col-md-12 ">
                        <!--<div class="card shadow p-4 bg-light">-->
                           
                           
                           
                           
                           
                            <div class="card-header">
                                <div class="row">
                                    
                                    
                                    <div class="col-6">
                                             
                                             
                                             
                                              <div class="card-body">
                                <div class="" data-example-id="hoverable-table">
                                    <table class="">
                                        <thead>
                                            <tr>
                                               
                                               
                                                <th><a class="btn btn-primary btn-sm float-right" type="button" href="list_parcel.php">
                                                    <span class="fa fa-gift-plus" data-fa-transform="shrink-3 down-2">&nbsp;Parcel List</span>
                                                   
                                                </a></th>
                                               
                                               
                                              
                                               
                                            </tr>
                                        </thead>
                                        </table>
                                        </div>
                                        </div>
                                        
                                       
                                                                            </div>
                                </div>
                            </div>
                            
                            
 <style>
/* scoped to just this form */
#parcel-form label {
  color: #007bff !important;
}

</style>

         <form id="parcel-form" method="POST" action="">
                        <input type="hidden" name="id" value="<?= htmlspecialchars($id) ?>">
                        <input type="hidden" name="action" value="update">

                       
                       
                       
                       
                       <br><br><br>
                       
                       
                       <h4 style="color:blue">Company Info</h4>
                        <label>Company Name</label>
                        <input type="text" name="comp_name" class="form-control"
                               value="<?= htmlspecialchars($ordrow['comp_name'] ?? '') ?>">

                        <label>Location</label>
                        <input type="text" name="comp_location" class="form-control"
                               value="<?= htmlspecialchars($ordrow['comp_location'] ?? '') ?>">

                        <label>Phone</label>
                        <input type="text" name="comp_phone" class="form-control"
                               value="<?= htmlspecialchars($ordrow['comp_phone'] ?? '') ?>">

                       
                       
                       
                       
                       <br><br><br>
                       
                       <h4 style="color:blue">Costs</h4>
                        <label>Shipping Cost</label>
                        <input type="text" name="ship_cost" class="form-control"
                               value="<?= htmlspecialchars($ordrow['ship_cost'] ?? '') ?>">

                        <label>Sub Cost</label>
                        <input type="text" name="sub_cost" class="form-control"
                               value="<?= htmlspecialchars($ordrow['sub_cost'] ?? '') ?>">

                        <label>Total Cost</label>
                        <input type="text" name="total_cost" class="form-control"
                               value="<?= htmlspecialchars($ordrow['total_cost'] ?? '') ?>">

                       
                       
                       
                       
                       <br><br><br>
                       
                       
                       
                       <h4 style="color:blue">Status</h4>
                        <label>Delivery Status</label>
                        <input type="text" name="delivery_status" class="form-control"
                               value="<?= htmlspecialchars($ordrow['delivery_status'] ?? '') ?>">

                        <label>Consignment Status</label>
                        <input type="text" name="consignment_status" class="form-control"
                               value="<?= htmlspecialchars($ordrow['consignment_status'] ?? '') ?>">

                      
                      
                      
                      
                      <br><br><br>
                      
                      
                      <h4 style="color:blue">Billing</h4>
                        <label>Billing Name</label>
                        <input type="text" name="billing_name" class="form-control"
                               value="<?= htmlspecialchars($ordrow['billing_name'] ?? '') ?>">

                        <label>Billing Cost</label>
                        <input type="text" name="billing_cost" class="form-control"
                               value="<?= htmlspecialchars($ordrow['billing_cost'] ?? '') ?>">





                      <br><br><br>
                      
                      <h4 style="color:blue">Logistics</h4>
                        <label>Current Location</label>
                        <input type="text" name="current_location" class="form-control"
                               value="<?= htmlspecialchars($ordrow['current_location'] ?? '') ?>">

                        <label>Final Destination</label>
                        <input type="text" name="final_destination" class="form-control"
                               value="<?= htmlspecialchars($ordrow['final_destination'] ?? '') ?>">

                        <label>Quantity</label>
                        <input type="text" name="consignment_quantity" class="form-control"
                               value="<?= htmlspecialchars($ordrow['consignment_quantity'] ?? '') ?>">

                        <label>Arrival Date</label>
                        <input type="date" name="arrival_date" class="form-control"
                               value="<?= htmlspecialchars($ordrow['arrival_date'] ?? '') ?>">

                        <label>Departure Date</label>
                        <input type="date" name="departure_date" class="form-control"
                               value="<?= htmlspecialchars($ordrow['departure_date'] ?? '') ?>">

                        <label>Arrival Time</label>
                        <input type="time" name="arrival_time" class="form-control"
                               value="<?= htmlspecialchars($ordrow['arrival_time'] ?? '') ?>">

                      
                      
                      
                        <br><br><br>
                        
                        <h4 style="color:blue">Parcel Info</h4>
                        <label>Parcel Name</label>
                        <input type="text" name="parcel_name" class="form-control"
                               value="<?= htmlspecialchars($ordrow['parcel_name'] ?? '') ?>">

                        <label>Details</label>
                        <textarea name="parcel_details" class="form-control"><?= htmlspecialchars($ordrow['parcel_details'] ?? '') ?></textarea>

                        <label>Shipment From</label>
                        <input type="text" name="shipment_from" class="form-control"
                               value="<?= htmlspecialchars($ordrow['shipment_from'] ?? '') ?>">

                        <label>Shipment To</label>
                        <input type="text" name="shipment_to" class="form-control"
                               value="<?= htmlspecialchars($ordrow['shipment_to'] ?? '') ?>">

                        <label>Tracking Code</label>
                        <input type="text" name="tracking_code" class="form-control"
                               value="<?= htmlspecialchars($ordrow['tracking_code'] ?? '') ?>">

                       
                       
                       
                       <br><br><br>
                       <h4 style="color:blue">Receiver Info</h4>
                        <label>Name</label>
                        <input type="text" name="recv_name" class="form-control"
                               value="<?= htmlspecialchars($ordrow['recv_name'] ?? '') ?>">

                        <label>Email</label>
                        <input type="email" name="recv_email" class="form-control"
                               value="<?= htmlspecialchars($ordrow['recv_email'] ?? '') ?>">

                        <label>Address</label>
                        <input type="text" name="recv_address" class="form-control"
                               value="<?= htmlspecialchars($ordrow['recv_address'] ?? '') ?>">

                        <label>Phone</label>
                        <input type="text" name="recv_phone" class="form-control"
                               value="<?= htmlspecialchars($ordrow['recv_phone'] ?? '') ?>">

                        <label>Location</label>
                        <input type="text" name="recv_location" class="form-control"
                               value="<?= htmlspecialchars($ordrow['recv_location'] ?? '') ?>">

                       
                       <br><br><br>
                       
                        <h4 style="color:blue">Sender Info</h4>
                        <label>Name</label>
                        <input type="text" name="sdr_name" class="form-control"
                               value="<?= htmlspecialchars($ordrow['sdr_name'] ?? '') ?>">

                        <label>Address</label>
                        <input type="text" name="sdr_address" class="form-control"
                               value="<?= htmlspecialchars($ordrow['sdr_address'] ?? '') ?>">

                        <label>Phone</label>
                        <input type="text" name="sdr_phone" class="form-control"
                               value="<?= htmlspecialchars($ordrow['sdr_phone'] ?? '') ?>">

                        <label>Location</label>
                        <input type="text" name="sdr_location" class="form-control"
                               value="<?= htmlspecialchars($ordrow['sdr_location'] ?? '') ?>">

                        <br>
                        <button type="submit" class="btn btn-success">Update Package</button>
                    </form>
</div>

  
            <hr>
    
    
  
        
          <br>
          
          	
            
            
        </div></div></div>
<!--=====================================-->

</div>

 <?php
require ("footer.php")
?>


