<?php 
require_once("header.php");
require_once("../config.php"); // must define $pdo here
session_start();

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$success_site = "";

// Fetch existing settings
$stmt = $pdo->prepare("SELECT * FROM settings WHERE id = ?");
$stmt->execute([$id]);
$ordrow = $stmt->fetch();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['info'])) {
    // Helper function to sanitize input
    function esc($value) {
        return trim($value);
    }

    // Get and sanitize values
    $title = esc($_POST['title']);
    $phone = esc($_POST['phone']);
    $email2 = esc($_POST['email2']);
    $url = esc($_POST['url']);
    $address = esc($_POST['address']);
    $country = esc($_POST['country']);
    $city = esc($_POST['city']);
    $state = esc($_POST['state']);
    
    $whatsapp = esc($_POST['whatsapp']);
    $service2 = esc($_POST['service2']);
    $service3 = esc($_POST['service3']);
    
    $welc_msg = esc($_POST['welc_msg']);
    $domain_name = esc($_POST['domain_name']);
    $copyright = esc($_POST['copyright']);
    $vision = esc($_POST['vision']);
    $mission = esc($_POST['mission']);
    $about_head = esc($_POST['about_head']);
    $about_msg = esc($_POST['about_msg']);
    $developa = esc($_POST['developa']);

    // Encryption
    // $ciphering = "AES-128-CTR";
    // $options = 0;
    // $encryption_iv = '1234567891011121';
    // $encryption_key = "W3docs";
    // $encrypted_developa = openssl_encrypt($developa, $ciphering, $encryption_key, $options, $encryption_iv);

    // Update query
    $update = $pdo->prepare("
        UPDATE settings SET  
            title = :title,
            phone = :phone,
            email2 = :email2,
            url = :url,
            address = :address,
            country = :country,
            city = :city,
            state = :state,
            
            whatsapp = :whatsapp,
            service2 = :service2,
            service3 = :service3,
            
            welc_msg = :welc_msg,
            domain_name = :domain_name,
            copyright = :copyright,
            vision = :vision,
            mission = :mission,
            about_head = :about_head,
            about_msg = :about_msg,
            developa = :developa
        WHERE id = :id
    ");

    $update->execute([
        ':title' => $title,
        ':phone' => $phone,
        ':email2' => $email2,
        ':url' => $url,
        ':address' => $address,
        ':country' => $country,
        ':city' => $city,
        ':state' => $state,
        
        ':whatsapp' => $whatsapp,
        ':service2' => $service2,
        ':service3' => $service3,
        ':welc_msg' => $welc_msg,
        ':domain_name' => $domain_name,
        ':copyright' => $copyright,
        ':vision' => $vision,
        ':mission' => $mission,
        ':about_head' => $about_head,
        ':about_msg' => $about_msg,
        ':developa' => $developa,
        ':id' => $id,
    ]);

    $success_site = "<div class='alert alert-success' style='margin-bottom:20px;'>Updated Successfully<meta http-equiv='refresh' content='3; url=?id=$id' /></div>";

    // Refresh the data
    $stmt = $pdo->prepare("SELECT * FROM settings WHERE id = ?");
    $stmt->execute([$id]);
    $ordrow = $stmt->fetch();
}
?>

<!-- HTML -->
<div class="main-panel">
    <div class="content bg-light">
        <div class="page-inner">
            <div class="mt-2 mb-4">
                <h1 class="title1 text-dark">Edit Site Info</h1>
            </div>

            <div class="mb-5 row">
                <div class="col-md-12">
                    <?php if (!empty($success_site)) echo $success_site; ?>

                    <form method="POST" enctype="multipart/form-data" action="">
                        <?php
                        function form_input($label, $name, $value, $readonly = false) {
                            $ro = $readonly ? "readonly" : "";
                            return "
                            <div class='form-group'>
                                <label class='form-control' for='$name'>$label</label>
                                <input type='text' class='form-control bg-light text-dark' name='$name' value='".htmlspecialchars($value)."' $ro><br>
                            </div>";
                        }

                        echo form_input("TITLE", "title", $ordrow['title']);
                        echo form_input("PHONE", "phone", $ordrow['phone']);
                        echo form_input("EMAIL", "email2", $ordrow['email2'], true);
                        echo form_input("URL", "url", $ordrow['url'], true);
                        echo form_input("Welcome Message", "welc_msg", $ordrow['welc_msg']);
                        echo form_input("Domain Name", "domain_name", $ordrow['domain_name']);
                        echo form_input("Site Header", "about_head", $ordrow['about_head']);
                        echo form_input("Site Message", "about_msg", $ordrow['about_msg']);
                        echo form_input("VISION", "vision", $ordrow['vision']);
                        echo form_input("MISSION", "mission", $ordrow['mission']);
                        echo form_input("COPYRIGHT", "copyright", $ordrow['copyright']);
                        echo form_input("ADDRESS", "address", $ordrow['address']);
                        echo form_input("COUNTRY", "country", $ordrow['country']);
                        echo form_input("CITY", "city", $ordrow['city']);
                        echo form_input("STATE", "state", $ordrow['state']);
                        
                        
                         echo form_input("WHATSAPP", "whatsapp", $ordrow['whatsapp']);
                         
                          echo form_input("TELEGRAM", "service2", $ordrow['service2']);
                          
                           echo form_input("WECHAT", "service3", $ordrow['service3']);
                        
                        echo form_input("Developer", "developa", $ordrow['developa']);
                        
                        ?>

                        <button type="submit" class="btn btn-success btn-block btn-lg" name="info">UPDATE SETTINGS</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require("footer.php"); ?>
