<?php 

require_once("header.php");
?>





        <div class="main-panel">
        <div class="content bg-light">
           
           
           
            <div class="panel-header bg-primary-gradient">
            <div class="py-5 page-inner">
                <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                    <div>
                        <h2 class="pb-2 text-white fw-bold">Dashboard</h2>
                        <h5 class="mb-2 text-white op-7">Welcome, Admin <?= htmlspecialchars($username) ?>!</h5> 
                    </div>
                    <div class="py-2 ml-md-auto py-md-0">
                        <a href="add_parcel.php" class="mr-2 btn btn-success btn-border">ADD PARCEL</a>
                        <a href="list_parcel.php" class="mr-2 btn btn-danger btn-border">VIEW PARCEL</a>
                        <!--<a href="adminverify.php" class="mr-2 btn btn-secondary btn-border">USERS</a>-->
                    </div>
                    <!--<div class="py-2 ml-md-auto py-md-0">-->
                    <!--    <a href="inbox.php" class="mr-2 btn btn-warning btn-border"><?= $inboxCount ?> INBOX</a>-->
                    <!--    <a href="outbox.php" class="mr-2 btn btn-warning btn-border"><?= $outboxCount ?> OUTBOX</a>-->
                    <!--</div>-->
                </div>
            </div>
        </div>
            
            
            
   
   
   
              <div class="page-inner mt--5">
               
               
               
               
               
               <?php 


// Fetch parcel stats using PDO
try {
    $stmtTotal = $pdo->query("SELECT COUNT(tracking_code) AS count FROM packages");
    $total = $stmtTotal->fetch(PDO::FETCH_ASSOC)['count'];

    $stmtPending = $pdo->prepare("SELECT COUNT(tracking_code) AS count FROM packages WHERE status = ?");
    $stmtPending->execute([0]);
    $pending = $stmtPending->fetch(PDO::FETCH_ASSOC)['count'];

    $stmtDelivered = $pdo->prepare("SELECT COUNT(tracking_code) AS count FROM packages WHERE status = ?");
    $stmtDelivered->execute([1]);
    $delivered = $stmtDelivered->fetch(PDO::FETCH_ASSOC)['count'];

    $stmtDeclined = $pdo->prepare("SELECT COUNT(tracking_code) AS count FROM packages WHERE status = ?");
    $stmtDeclined->execute([2]);
    $declined = $stmtDeclined->fetch(PDO::FETCH_ASSOC)['count'];
} catch (PDOException $e) {
    die("Failed to retrieve parcel statistics: " . $e->getMessage());
}
?>

<div class="row row-card-no-pd bg-light shadow-lg mt--2">
    <?php
    $stats = [
        'TOTAL PARCEL'      => $total,
        'PENDING PARCEL(s)' => $pending,
        'DELIVERED PARCEL'  => $delivered,
        'DECLINED PARCEL'   => $declined
    ];
    foreach ($stats as $label => $value): ?>
        <div class="col-sm-6 col-md-3">
            <div class="card card-stats card-round bg-light full-height">
                <div class="card-body">
                    <div class="row">
                        <div class="col-4 text-center icon-big">
                            <i class="fa fa-truck" style="font-size:48px;color:red"></i>
                        </div>
                        <div class="col-8 col-stats">
                            <div class="numbers">
                                <p class="card-category"><?= $label ?></p>
                                <?= $value ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>






  <div class="row mt-4">
                <div class="col-md-12">
                    <div class="overflow-auto">
                        <canvas id="myChart" height="100" class="text-dark"></canvas>
                    </div>
                    <script>
                        const ctx = document.getElementById('myChart').getContext('2d');
                        const myChart = new Chart(ctx, {
                            type: 'bar',
                            data: {
                                labels: ['DELIVERED', 'PENDING', 'DECLINED', 'PROCESSING', 'TOTAL'],
                                datasets: [{
                                    label: "# System Statistics",
                                    data: [<?= "$delivered, $pending, $declined, $processing, $total" ?>],
                                    backgroundColor: [
                                        'rgba(255, 99, 132, 0.2)',
                                        'rgba(54, 162, 235, 0.2)',
                                        'rgba(255, 206, 86, 0.2)',
                                        'rgba(75, 192, 192, 0.2)',
                                        'rgba(153, 102, 255, 0.2)'
                                    ],
                                    borderColor: [
                                        'rgba(255, 99, 132, 1)',
                                        'rgba(54, 162, 235, 1)',
                                        'rgba(255, 206, 86, 1)',
                                        'rgba(75, 192, 192, 1)',
                                        'rgba(153, 102, 255, 1)'
                                    ],
                                    borderWidth: 1
                                }]
                            },
                            options: {
                                responsive: true,
                                scales: {
                                    y: {
                                        beginAtZero: true
                                    }
                                }
                            }
                        });
                    </script>
                </div>
            </div>

            </div>
        </div>
                 
                 
                
                    
                    
                    <?php require ("footer.php") ?>