<?php 
require_once("header.php");

// Ensure PDO throws exceptions for debugging
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$id = $_GET['id'] ?? null;
$success = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    try {
        $pdo->beginTransaction();

        // === UPDATE `packages` TABLE ===
        $updatePackage = $pdo->prepare("
            UPDATE packages SET  
                pack = 0,
                delivery_status = :delivery_status,
                consignment_status = :consignment_status,
                billing_name = :billing_name,
                billing_cost = :billing_cost,
                current_location = :current_location,
                final_destination = :final_destination,
                consignment_quantity = :consignment_quantity,
                arrival_date = :arrival_date,
                departure_date = :departure_date,
                arrival_time = :arrival_time,
                parcel_name = :parcel_name,
                parcel_details = :parcel_details,
                tracking_code = :tracking_code,
                recv_name = :recv_name,
                recv_email = :recv_email,
                recv_address = :recv_address,
                recv_phone = :recv_phone,
                recv_location = :recv_location,
                sdr_name = :sdr_name,
                sdr_address = :sdr_address,
                sdr_phone = :sdr_phone,
                sdr_location = :sdr_location
            WHERE id = :id
        ");

        $updatePackage->execute([
            ':delivery_status' => $_POST['delivery_status'],
            ':consignment_status' => $_POST['consignment_status'],
            ':billing_name' => $_POST['billing_name'],
            ':billing_cost' => $_POST['billing_cost'],
            ':current_location' => $_POST['current_location'],
            ':final_destination' => $_POST['final_destination'],
            ':consignment_quantity' => $_POST['consignment_quantity'],
            ':arrival_date' => $_POST['arrival_date'],
            ':departure_date' => $_POST['departure_date'],
            ':arrival_time' => $_POST['arrival_time'],
            ':parcel_name' => $_POST['parcel_name'],
            ':parcel_details' => $_POST['parcel_details'],
            ':tracking_code' => $_POST['tracking_code'],
            ':recv_name' => $_POST['recv_name'],
            ':recv_email' => $_POST['recv_email'],
            ':recv_address' => $_POST['recv_address'],
            ':recv_phone' => $_POST['recv_phone'],
            ':recv_location' => $_POST['recv_location'],
            ':sdr_name' => $_POST['sdr_name'],
            ':sdr_address' => $_POST['sdr_address'],
            ':sdr_phone' => $_POST['sdr_phone'],
            ':sdr_location' => $_POST['sdr_location'],
            ':id' => $id
        ]);

        // === MARK PREVIOUS LOCATION AS INACTIVE ===
        $pdo->prepare("UPDATE locations SET green = 0 WHERE trackid = :id")
            ->execute([':id' => $id]);

        // === INSERT NEW LOCATION INTO `locations` ===
        $insertLocation = $pdo->prepare("
            INSERT INTO locations (
                trackid, comp_name, comp_location, comp_phone, ship_cost, sub_cost, total_cost,
                delivery_status, consignment_status, billing_name, billing_cost,
                current_location, current_address, final_destination, consignment_quantity,
                arrival_date, arrival_time, departure_date, parcel_name, parcel_details,
                tracking_code, recv_name, recv_email, recv_address,
                recv_phone, recv_location, sdr_name, sdr_address, sdr_phone, sdr_location, green, date
            ) VALUES (
                :trackid, :comp_name, :comp_location, :comp_phone, :ship_cost, :sub_cost, :total_cost,
                :delivery_status, :consignment_status, :billing_name, :billing_cost,
                :current_location, :current_address, :final_destination, :consignment_quantity,
                :arrival_date, :arrival_time, :departure_date, :parcel_name, :parcel_details,
                :tracking_code, :recv_name, :recv_email, :recv_address,
                :recv_phone, :recv_location, :sdr_name, :sdr_address, :sdr_phone, :sdr_location, 1, :date
            )
        ");

        $insertLocation->execute([
            ':trackid' => $_POST['trackid'],
            ':comp_name' => $_POST['comp_name'],
            ':comp_location' => $_POST['comp_location'],
            ':comp_phone' => $_POST['comp_phone'],
            ':ship_cost' => $_POST['ship_cost'],
            ':sub_cost' => $_POST['sub_cost'],
            ':total_cost' => $_POST['total_cost'],
            ':delivery_status' => $_POST['delivery_status'],
            ':consignment_status' => $_POST['consignment_status'],
            ':billing_name' => $_POST['billing_name'],
            ':billing_cost' => $_POST['billing_cost'],
            ':current_location' => $_POST['current_location'],
            ':current_address' => $_POST['sdr_address'], // ✅ FIXED
            ':final_destination' => $_POST['final_destination'],
            ':consignment_quantity' => $_POST['consignment_quantity'],
            ':arrival_date' => $_POST['arrival_date'],
            ':arrival_time' => $_POST['arrival_time'],
            ':departure_date' => $_POST['departure_date'],
            ':parcel_name' => $_POST['parcel_name'],
            ':parcel_details' => $_POST['parcel_details'],
            ':tracking_code' => $_POST['tracking_code'],
            ':recv_name' => $_POST['recv_name'],
            ':recv_email' => $_POST['recv_email'],
            ':recv_address' => $_POST['recv_address'],
            ':recv_phone' => $_POST['recv_phone'],
            ':recv_location' => $_POST['recv_location'],
            ':sdr_name' => $_POST['sdr_name'],
            ':sdr_address' => $_POST['sdr_address'],
            ':sdr_phone' => $_POST['sdr_phone'],
            ':sdr_location' => $_POST['sdr_location'],
            ':date' => date('Y-m-d H:i:s')
        ]);

        $pdo->commit();
        $success = "<div class='alert alert-success'>Parcel location updated successfully. <meta http-equiv='refresh' content='5'></div>";

    } catch (PDOException $e) {
        $pdo->rollBack();
        $success = "<div class='alert alert-danger'>Error: {$e->getMessage()}</div>";
    }
}

if (!empty($success)) echo $success;

// === FETCH PACKAGE INFO FOR FORM ===
$stmt = $pdo->prepare("SELECT * FROM packages WHERE id = :id");
$stmt->execute([':id' => $id]);
$ordrow = $stmt->fetch();

if (!$ordrow) {
    die("Package not found.");
}

?>

<div class="main-panel">
    <div class="content bg-light">
        <div class="page-inner">
            <div class="mt-2 mb-4">
                <h1 class="title1 text-dark">Edit Location</h1>
            </div>

            <center><legend>CHANGE PACKAGE LOCATION</legend></center>

            <?php if (!empty($success)) echo $success; ?>

            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="action" value="update_location">
                <input type="hidden" name="trackid" value="<?= htmlspecialchars($ordrow['id']) ?>">

                <div class="form-group">
                    <label for="delivery_status" style="color:black !important;">Delivery Status</label>
                    <select name="delivery_status" class="form-control">
                        <option selected value="<?= htmlspecialchars($ordrow['delivery_status']) ?>">
                            <?= htmlspecialchars($ordrow['delivery_status']) ?>
                        </option>
                        <option value="Ready">Ready</option>
                        <option value="Finished">Finished</option>
                        <option value="In-Transit">In-Transit</option>
                        <option value="On-Hold">On-Hold</option>
                        <option value="Landed">Landed</option>
                        <option value="Delayed">Delayed</option>
                        <option value="Custom Clearance">Custom Clearance</option>
                        <option value="On Route">On Route</option>
                        <option value="Delivered">Delivered</option>
                        <option value="Custom Carrier">Custom Carrier</option>
                        <option value="Clearance">Clearance</option>
                        <option value="Permit">Permit</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="consignment_status" style="color:black !important;">Consignment Status</label>
                    <input type="text" name="consignment_status" class="form-control"
                        value="<?= htmlspecialchars($ordrow['consignment_status']) ?>">
                </div>

                <div class="form-group">
                    <label for="billing_name" style="color:black !important;">Billing Name</label>
                    <input type="text" name="billing_name" class="form-control"
                        value="<?= htmlspecialchars($ordrow['billing_name']) ?>">
                </div>

                <div class="form-group">
                    <label for="billing_cost" style="color:black !important;">Billing Cost</label>
                    <input type="text" name="billing_cost" class="form-control"
                        value="<?= htmlspecialchars($ordrow['billing_cost']) ?>">
                </div>

                <div class="form-group">
                    <label for="sdr_address" style="color:black !important;">Current Address</label>
                    <input type="text" name="sdr_address" class="form-control"
                        value="<?= htmlspecialchars($ordrow['sdr_address']) ?>">
                </div>

                <div class="form-group">
                    <label for="current_location" style="color:black !important;">Current Location</label>
                    <select name="current_location" class="form-control">
                        <?php
                        $countries = [
                            "Afghanistan","Albania","Algeria","Andorra","Angola","Antigua and Barbuda","Argentina","Armenia",
                            "Australia","Austria","Azerbaijan","Bahamas","Bahrain","Bangladesh","Barbados","Belarus","Belgium",
                            "Belize","Benin","Bhutan","Bolivia","Bosnia and Herzegovina","Botswana","Brazil","Brunei",
                            "Bulgaria","Burkina Faso","Burundi","Cabo Verde","Cambodia","Cameroon","Canada","Central African Republic",
                            "Chad","Chile","China","Colombia","Comoros","Congo (Brazzaville)","Congo (Kinshasa)","Costa Rica",
                            "Croatia","Cuba","Cyprus","Czech Republic","Denmark","Djibouti","Dominica","Dominican Republic",
                            "Ecuador","Egypt","El Salvador","Equatorial Guinea","Eritrea","Estonia","Eswatini","Ethiopia",
                            "Fiji","Finland","France","Gabon","Gambia","Georgia","Germany","Ghana","Greece","Grenada","Guatemala",
                            "Guinea","Guinea-Bissau","Guyana","Haiti","Honduras","Hungary","Iceland","India","Indonesia","Iran",
                            "Iraq","Ireland","Israel","Italy","Jamaica","Japan","Jordan","Kazakhstan","Kenya","Kiribati","Kuwait",
                            "Kyrgyzstan","Laos","Latvia","Lebanon","Lesotho","Liberia","Libya","Liechtenstein","Lithuania",
                            "Luxembourg","Madagascar","Malawi","Malaysia","Maldives","Mali","Malta","Marshall Islands","Mauritania",
                            "Mauritius","Mexico","Micronesia","Moldova","Monaco","Mongolia","Montenegro","Morocco","Mozambique",
                            "Myanmar","Namibia","Nauru","Nepal","Netherlands","New Zealand","Nicaragua","Niger","Nigeria",
                            "North Korea","North Macedonia","Norway","Oman","Pakistan","Palau","Palestine","Panama","Papua New Guinea",
                            "Paraguay","Peru","Philippines","Poland","Portugal","Qatar","Romania","Russia","Rwanda","Saint Kitts and Nevis",
                            "Saint Lucia","Saint Vincent and the Grenadines","Samoa","San Marino","Sao Tome and Principe","Saudi Arabia",
                            "Senegal","Serbia","Seychelles","Sierra Leone","Singapore","Slovakia","Slovenia","Solomon Islands",
                            "Somalia","South Africa","South Korea","South Sudan","Spain","Sri Lanka","Sudan","Suriname","Sweden",
                            "Switzerland","Syria","Taiwan","Tajikistan","Tanzania","Thailand","Timor-Leste","Togo","Tonga",
                            "Trinidad and Tobago","Tunisia","Turkey","Turkmenistan","Tuvalu","Uganda","Ukraine","United Arab Emirates",
                            "United Kingdom","United States","Uruguay","Uzbekistan","Vanuatu","Vatican City","Venezuela","Vietnam",
                            "Yemen","Zambia","Zimbabwe"
                        ];
                        $selectedCountry = htmlspecialchars($ordrow['current_location']);
                        foreach ($countries as $country) {
                            $selected = ($country === $selectedCountry) ? 'selected' : '';
                            echo "<option value=\"$country\" $selected>$country</option>";
                        }
                        ?>
                    </select>
                </div>

                <!-- Hidden Fields -->
                <?php
                $fields = [
                    'comp_name', 'comp_location', 'comp_phone', 'ship_cost',
                    'sub_cost', 'total_cost', 'final_destination', 'consignment_quantity',
                    'departure_date', 'arrival_date', 'parcel_name', 'parcel_details',
                    'tracking_code', 'recv_name', 'recv_email', 'recv_address',
                    'recv_phone', 'recv_location', 'sdr_name',
                    'sdr_phone', 'sdr_location'
                ];

                foreach ($fields as $field) {
                    echo "<input type='hidden' name='{$field}' value='" . htmlspecialchars($ordrow[$field]) . "'>\n";
                }
                ?>

                <div class="form-group">
                    <label for="arrival_time" style="color:black !important;">Current Time</label>
                    <input type="text" name="arrival_time" class="form-control" value="<?= date('g:iA') ?>">
                </div>

                <button type="submit" class="btn btn-success">Update Location</button>
            </form>

        </div>
    </div>
</div>

<?php require("footer.php"); ?>
